(function ($) {
  Drupal.behaviors.trizzy_theme = {
    attach: function (context, settings) {

      /* === Tabs ==== */
      //----------------------------------------//
      $('#trizzyTab a').click(function (e) {
        e.preventDefault();
        $(this).tab('show');
      });
      /*==== End Tabs ===== */

      /* === Product add to cart quantity ==== */


      $commerce_qty_default = '<input type="text" class="form-text form-control qty" maxlength="128" size="5" value="1" name="quantity" id="edit-quantity">';
      var $commerce_qty_alter = '<div class="qtyminus"></div>' + $commerce_qty_default + '<div class="qtyplus"></div>';
      $('.commerce-add-to-cart .form-item-quantity').html($commerce_qty_alter);

      var thisrowfield;
      $('.qtyplus').click(function (e) {
        e.preventDefault();
        thisrowfield = $(this).parent().parent().parent().find('.qty');

        var currentVal = parseInt(thisrowfield.val());
        if (!isNaN(currentVal)) {
          thisrowfield.val(currentVal + 1);
        } else {
          thisrowfield.val(0);
        }
      });

      $(".qtyminus").click(function (e) {
        e.preventDefault();
        thisrowfield = $(this).parent().parent().parent().find('.qty');
        var currentVal = parseInt(thisrowfield.val());
        if (!isNaN(currentVal) && currentVal > 0) {
          thisrowfield.val(currentVal - 1);
        } else {
          thisrowfield.val(0);
        }
      });

      /* =======End Product add to cart quantity ========== */



      /* ========= Custom select box ============= */
      $('.views-exposed-form .form-select').selectric();
      /* ========== End Custom Select Box =========== */


      /* ===== Cart header function ======== */
      $("#cart").hoverIntent({
        sensitivity: 3,
        interval: 60,
        over: function () {
          $('.cart-list', this).fadeIn(200);
          $('.cart-btn a.button', this).addClass('hovered');
        },
        timeout: 220,
        out: function () {
          $('.cart-list', this).fadeOut(100);
          $('.cart-btn a.button', this).removeClass('hovered');
        }
      });
      /* ====== End Cart header function ===== */


      /* ===== Share buttons ================== */
      var $Filter = $('.share-buttons');
      var FilterTimeOut;
      $Filter.find('ul li:first').addClass('active');
      $Filter.find('ul li:not(.active)').hide();
      $Filter.hover(function () {
        clearTimeout(FilterTimeOut);
        if ($(window).width() < 959)
        {
          return;
        }
        FilterTimeOut = setTimeout(function () {
          $Filter.find('ul li:not(.active)').stop(true, true).animate({width: 'show'}, 250, 'swing');
          $Filter.find('ul li:first-child a').addClass('share-hovered');
        }, 100);

      }, function () {
        if ($(window).width() < 960)
        {
          return;
        }
        clearTimeout(FilterTimeOut);
        FilterTimeOut = setTimeout(function () {
          $Filter.find('ul li:not(.active)').stop(true, true).animate({width: 'hide'}, 250, 'swing');
          $Filter.find('ul li:first-child a').removeClass('share-hovered');

        }, 250);
      });
      $(window).resize(function () {
        if ($(window).width() < 960)
        {
          $Filter.find('ul li:not(.active)').show();
        }
        else
        {
          $Filter.find('ul li:not(.active)').hide();
        }
      });
      $(window).resize();
      /* ====== End Share buttons  ============= */


      /* ====== Popup box ========== */
      $('.popup-youtube, .popup-vimeo, .popup-gmaps, .popup-video').magnificPopup({
        disableOn: 700,
        type: 'iframe',
        fixedContentPos: false,
        fixedBgPos: false,
        removalDelay: 300,
        mainClass: 'mfp-fade',
        preloader: false
      });
      /* ======= End popup Box ======= */


    }
  };
})(jQuery);



(function ($) {

  /* ====== Wishlist click reload a page ====== */
  $(document).bind('flagGlobalAfterLinkUpdate', function (event, data) {
    //console.log()
    //location.reload();
  });
  /* ====== End Wishlist reload page ======== */


  $(document).ready(function () {
    // Mobile Navigation
    //----------------------------------------//

    var jPanelMenu = $.jPanelMenu({
      menu: '#navigation .sf-menu',
      animated: false,
      keyboardShortcuts: true
    });
    jPanelMenu.on();

    $(document).on('click', jPanelMenu.menu + ' li a', function (e) {
      if (jPanelMenu.isOpen() && $(e.target).attr('href').substring(0, 1) === '#') {
        jPanelMenu.close();
      }
    });

    $(document).on('touchend', '.menu-trigger', function (e) {
      jPanelMenu.triggerMenu();
      e.preventDefault();
      return false;
    });

    // Removes SuperFish Styles
    $('#jPanelMenu-menu').removeClass('sf-menu');
    $('ul#jPanelMenu-menu').find('li').removeClass('sf-hidden');
    $('ul#jPanelMenu-menu').find('ul').removeClass('sf-hidden');
    $('ul#jPanelMenu-menu li ul').removeAttr('style');
    $('ul#jPanelMenu-menu li div').removeClass('mega');
    $('ul#jPanelMenu-menu li div').removeAttr('style');
    $('ul#jPanelMenu-menu li div div').removeClass('mega-container');


    $(window).resize(function () {

      var winWidth = $(window).width();

      if (winWidth > 767) {
        jPanelMenu.close();
      }
    });


    // Accordion
    //----------------------------------------//

    var $accor = $('.accordion');

    $accor.each(function () {
      $(this).addClass('ui-accordion ui-widget ui-helper-reset');
      $(this).find('h3').addClass('ui-accordion-header ui-helper-reset ui-state-default ui-accordion-icons ui-corner-all');
      $(this).find('div').addClass('ui-accordion-content ui-helper-reset ui-widget-content ui-corner-bottom');
      $(this).find("div").hide().first().show();
      $(this).find("h3").first().removeClass('ui-accordion-header-active ui-state-active ui-corner-top').addClass('ui-accordion-header-active ui-state-active ui-corner-top');
      $(this).find("span").first().addClass('ui-accordion-icon-active');
    });

    var $trigger = $accor.find('h3');

    $trigger.on('click', function (e) {
      var location = $(this).parent();

      if ($(this).next().is(':hidden')) {
        var $triggerloc = $('h3', location);
        $triggerloc.removeClass('ui-accordion-header-active ui-state-active ui-corner-top').next().slideUp(300);
        $triggerloc.find('span').removeClass('ui-accordion-icon-active');
        $(this).find('span').addClass('ui-accordion-icon-active');
        $(this).addClass('ui-accordion-header-active ui-state-active ui-corner-top').next().slideDown(300);
      }
      e.preventDefault();
    });

    /* ==== End Accordion ===== */

    $('#footer .block-simplenews .form-item-mail label').click(function () {
      $(this).hide();
    });
    $email_text_value = $('#footer .block-simplenews .form-item-mail .form-text').val();
    if ($email_text_value) {
      $('#footer .block-simplenews .form-item-mail label').hide();
    }


    if ($('.google-map').length) {
      $('.titlebar,.alert').css('margin-bottom', 0);
    }

    // Skill Bars Animation
    //----------------------------------------//

    if ($('#skillzz').length !== 0) {
      var skillbar_active = false;
      $('.skill-bar-value').hide();

      if ($(window).scrollTop() === 0 && isScrolledIntoView($('#skillzz')) === true) {
        skillbarActive();
        skillbar_active = true;
      }
      else if (isScrolledIntoView($('#skillzz')) === true) {
        skillbarActive();
        skillbar_active = true;
      }
      $(window).bind('scroll', function () {
        if (skillbar_active === false && isScrolledIntoView($('#skillzz')) === true) {
          skillbarActive();
          skillbar_active = true;
        }
      });
    }

    function isScrolledIntoView(elem) {
      var docViewTop = $(window).scrollTop();
      var docViewBottom = docViewTop + $(window).height();

      var elemTop = $(elem).offset().top;
      var elemBottom = elemTop + $(elem).height();

      return ((elemBottom <= (docViewBottom + $(elem).height())) && (elemTop >= (docViewTop - $(elem).height())));
    }

    function skillbarActive() {
      setTimeout(function () {

        $('.skill-bar-value').each(function () {
          $(this)
                  .data("origWidth", $(this)[0].style.width)
                  .css('width', '1%').show();
          $(this)
                  .animate({
                    width: $(this).data("origWidth")
                  }, 1200);
        });

        $('.skill-bar-value .dot').each(function () {
          var me = $(this);
          var perc = me.attr("data-percentage");

          var current_perc = 0;

          var progress = setInterval(function () {
            if (current_perc >= perc) {
              clearInterval(progress);
            } else {
              current_perc += 1;
              me.text((current_perc) + '%');
            }
          }, 10);
        });
      }, 10);
    }


    // counter 
    $('.counter').counterUp({
      delay: 10,
      time: 2000
    });

    // Tooltips
    //----------------------------------------//

    $(".tooltip.top").tipTip({
      defaultPosition: "top"
    });

    $(".tooltip.bottom").tipTip({
      defaultPosition: "bottom"
    });

    $(".tooltip.left").tipTip({
      defaultPosition: "left"
    });

    $(".tooltip.right").tipTip({
      defaultPosition: "right"
    });

    // Toggles
    //----------------------------------------//
    $(".toggle-container").hide();
    $(".trigger").toggle(function () {
      $(this).addClass("active");
    }, function () {
      $(this).removeClass("active");
    });
    $(".trigger").click(function () {
      $(this).next(".toggle-container").slideToggle();
    });

    $(".trigger.opened").toggle(function () {
      $(this).removeClass("active");
    }, function () {
      $(this).addClass("active");
    });

    $(".trigger.opened").addClass("active").next(".toggle-container").show();


// Tabs
    //----------------------------------------//
    var $tabsNav = $('.tabs-nav'),
            $tabsNavLis = $tabsNav.children('li');
    // $tabContent = $('.tab-content');

    $tabsNav.each(function () {
      var $this = $(this);

      $this.next().children('.tab-content').stop(true, true).hide()
              .first().show();

      $this.children('li').first().addClass('active').stop(true, true).show();
    });

    $tabsNavLis.on('click', function (e) {
      var $this = $(this);

      $this.siblings().removeClass('active').end()
              .addClass('active');

      $this.parent().next().children('.tab-content').stop(true, true).hide()
              .siblings($this.find('a').attr('href')).fadeIn();

      e.preventDefault();
    });

    //notification box


    $(".notification a.close").removeAttr("href").click(function () {
      $(this).parent().fadeOut(200);
    });


    /*==== Your Js Custom Place Here====*/
  });



  $(window).load(function () {
    var $location_hash = window.location.hash;
    if ($location_hash.indexOf("#comment") > -1) {
      $('#trizzyTab li:eq(1) a').tab('show');
    }

  });

})(jQuery);