<?php
/**
 * @file
 * Default theme implementation to provide an HTML container for comments.
 *
 * Available variables:
 * - $content: The array of content-related elements for the node. Use
 *   render($content) to print them all, or
 *   print a subset such as render($content['comment_form']).
 * - $classes: String of classes that can be used to style contextually through
 *   CSS. It can be manipulated through the variable $classes_array from
 *   preprocess functions. The default value has the following:
 *   - comment-wrapper: The current template type, i.e., "theming hook".
 * - $title_prefix (array): An array containing additional output populated by
 *   modules, intended to be displayed in front of the main title tag that
 *   appears in the template.
 * - $title_suffix (array): An array containing additional output populated by
 *   modules, intended to be displayed after the main title tag that appears in
 *   the template.
 *
 * The following variables are provided for contextual information.
 * - $node: Node object the comments are attached to.
 * The constants below the variables show the possible values and should be
 * used for comparison.
 * - $display_mode
 *   - COMMENT_MODE_FLAT
 *   - COMMENT_MODE_THREADED
 *
 * Other variables:
 * - $classes_array: Array of html class attribute values. It is flattened
 *   into a string within the variable $classes.
 *
 * @see template_preprocess_comment_wrapper()
 *
 * @ingroup themeable
 */
$comment_count = !empty($node->comment_count) ? $node->comment_count : 0;
?>
<div id="comments" class="<?php print $classes; ?>"<?php print $attributes; ?>>
  <?php if ($content['comments'] && $node->type != 'forum' && $node->type != 'product' && $node->type != 'product_display'): ?>
    <?php print render($title_prefix); ?>
    <h3 class="title comment-form headline"><?php print t('Comments'); ?><span class="comments-amount">(<?php print $comment_count; ?>)</span></h3>
    <span class="line"></span>
    <div class="clearfix"></div>
    <?php print render($title_suffix); ?>
  <?php endif; ?>
  <?php if ($node->type == 'product_display' && empty($node->comment_count)): ?>
    <p><?php print t('There are no reviews yet.'); ?></p>
  <?php endif; ?>
  <?php print render($content['comments']); ?>

  <?php if ($content['comment_form']): ?>
    <?php if ($node->type == 'product_display' || $node->type == 'product'): ?>
      <h2 class="title comment-form"><?php print t('Add review'); ?></h2>
    <?php else: ?>
      <h3 class="title comment-form headline"><?php print t('Write a comment'); ?></h3>
      <span class="line"></span>
      <div class="clearfix"></div>
    <?php endif; ?>
    <?php print render($content['comment_form']); ?>
  <?php endif; ?>
</div>
