
<div id="wrapper">

  <?php if ($page['top_bar_left'] || $page['top_bar_right']): ?>
    <div id="top-bar">
      <div class="container">
        <div class="row">
          <?php if ($page['top_bar_left']): ?>
            <div class="top-bar-left col-md-4">
              <?php print render($page['top_bar_left']); ?>
            </div>
          <?php endif; ?>
          <?php if ($page['top_bar_right']): ?>
            <div class="top-bar-right col-md-8">
              <?php print render($page['top_bar_right']); ?>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
    <div class="clearfix"></div>
  <?php endif; ?>

  <!-- Header
  ================================================== -->
  <div class="container">
    <div class="row">
      <div class="col-md-4 col-sm-4">
        <div id="logo">
          <?php if ($logo): ?>
            <a href="<?php print $front_page; ?>" title="<?php print t('Home'); ?>" rel="home">
              <img src="<?php print $logo; ?>" alt="<?php print t('Home'); ?>" />
            </a>
          <?php endif; ?>

          <?php if ($site_name || $site_slogan): ?>
            <div id="name-and-slogan">
              <?php if ($site_name): ?>
                <?php if ($title): ?>
                  <div id="site-name"><strong>
                      <a href="<?php print $front_page; ?>" title="<?php print t('Home'); ?>" rel="home"><span><?php print $site_name; ?></span></a>
                    </strong></div>
                <?php else: /* Use h1 when the content title is empty */ ?>
                  <h1 id="site-name">
                    <a href="<?php print $front_page; ?>" title="<?php print t('Home'); ?>" rel="home"><span><?php print $site_name; ?></span></a>
                  </h1>
                <?php endif; ?>
              <?php endif; ?>

              <?php if ($site_slogan): ?>
                <div id="site-slogan"><?php print $site_slogan; ?></div>
              <?php endif; ?>
            </div> <!-- /#name-and-slogan -->
          <?php endif; ?>
        </div>
      </div>
      <?php if ($page['header_shopping_cart'] || $page['user_menu'] || $page['header_search']): ?>
        <div id="header-wrapper" class="col-md-8 col-sm-8">
          <?php if ($page['user_menu']): ?>
            <div id="user-menu-wrapper" class="clearfix">
              <?php print render($page['user_menu']); ?>
            </div>
          <?php endif; ?>
          <?php if ($page['header_shopping_cart'] || $page['header_search']): ?>
            <div id="search-cart-wrapper">
              <?php if ($page['header_shopping_cart']): ?>
                <?php if (module_exists('commerce_cart')): ?>
                  <?php
                  $order_amount = 0;
                  $order_currency_code = commerce_default_currency();
                  global $user;
                  if ($order = commerce_cart_order_load($user->uid)) {
                    $wrapper = entity_metadata_wrapper('commerce_order', $order);
					
                    $order_total = $wrapper->commerce_order_total->value();
                    if (isset($order_total['amount'])) {
                      $order_amount = $order_total['amount'];
                    }
                    if (isset($order_total['currency_code'])) {
                      $order_currency_code = $order_total['currency_code'];
                    }
                  }
                  ?>
                  <div id="cart">
                    <div class="cart-btn">
                      <a class="button adc" href="#"><?php print commerce_currency_format($order_amount, $order_currency_code); ?></a>
                    </div>
                  <?php endif; ?>
                  <div class="cart-list">
                    <?php print render($page['header_shopping_cart']); ?>
                  </div>
                </div>

              <?php endif; ?>
              <?php if ($page['header_search']): ?>
                <div class="top-search">
                  <?php print render($page['header_search']); ?>
                </div>
              <?php endif; ?>
              <div class="clearfix"></div>
            </div>
          <?php endif; ?>
        </div>
      <?php endif; ?>
    </div>
  </div>


  <?php if ($page['main_navigation']): ?>
    <div class="container">
      <div class="row">
        <div class="col-md-12">
          <a href="#menu" class="menu-trigger"><i class="fa fa-bars"></i> <?php print t('Menu'); ?></a>
          <nav id="navigation">
            <?php print render($page['main_navigation']); ?>
          </nav>
        </div>
      </div>
    </div>
  <?php endif; ?>

  <?php if (!empty($title) && !$page['parallax_breadcrumb']): ?>
    <section class="titlebar">
      <div class="container">
        <div class="sixteen columns">
          <?php if ($title): ?>
            <h1 id="page-title"><?php print $title; ?></h1>
          <?php endif; ?>
          <?php if ($breadcrumb): ?>
            <nav id="breadcrumbs">
              <?php print $breadcrumb; ?>
            </nav>
          <?php endif; ?>
        </div>
      </div>
    </section>
  <?php endif; ?>
  <?php if ($page['parallax_breadcrumb']): ?>
    <?php print render($page['parallax_breadcrumb']); ?>
  <?php endif; ?>

  <div class="main-wrapper">
    <div id="main">
      <div class="container">
        <div class="row">
          <?php if ($page['sidebar_first']): ?>
            <div id="sidebar-second" class="col-md-3 sidebar">
              <?php print render($page['sidebar_first']); ?>
            </div>
          <?php endif; ?>

          <div id="main-page-content"<?php print $content_column_class; ?>>
            <?php if (!empty($page['highlighted'])): ?>
              <div class="highlighted jumbotron"><?php print render($page['highlighted']); ?></div>
            <?php endif; ?>
            <a id="main-content"></a>
            <?php if (!empty($title_prefix) || !empty($title_suffix)): ?>
              <div class="title-suffix-prefix">
                <?php print render($title_prefix); ?>
                <?php print render($title_suffix); ?>
              </div>
            <?php endif; ?>

            <?php print $messages; ?>
            <?php if (!empty($tabs)): ?>
              <?php print render($tabs); ?>
            <?php endif; ?>
            <?php if (!empty($page['help'])): ?>
              <?php print render($page['help']); ?>
            <?php endif; ?>
            <?php if (!empty($action_links)): ?>
              <ul class="action-links"><?php print render($action_links); ?></ul>
            <?php endif; ?>
            <?php print render($page['content']); ?>
          </div>
          <?php if ($page['sidebar_second']): ?>
            <div id="sidebar-first" class="col-md-3 sidebar">
              <?php print render($page['sidebar_second']); ?>
            </div>
          <?php endif; ?>


        </div>
      </div>
    </div>

  </div>


  <?php if ($page['footer_first'] || $page['footer_second'] || $page['footer_third'] || $page['footer_fourth']): ?>
    <div id="footer">
      <div class="container">
        <div class="row">
          <?php if ($page['footer_first']): ?>
            <aside class="col-md-3 widget">
              <?php print render($page['footer_first']); ?>
            </aside>
          <?php endif; ?>

          <?php if ($page['footer_second']): ?>
            <aside class="col-md-3 widget">
              <?php print render($page['footer_second']); ?>
            </aside>
          <?php endif; ?>

          <?php if ($page['footer_third']): ?>
            <aside class="col-md-3 widget">
              <?php print render($page['footer_third']); ?>
            </aside>
          <?php endif; ?>

          <?php if ($page['footer_fourth']): ?>
            <aside class="col-md-3 widget">
              <?php print render($page['footer_fourth']); ?>
            </aside>
          <?php endif; ?>

        </div>
      </div>
    </div>
  <?php endif; ?>

  <?php if ($page['footer']): ?>
    <div id="footer-bottom">
      <!-- Container -->
      <div class="container">
        <div class="row">
          <div class="col-md-12">
            <?php print render($page['footer']); ?>
          </div>
        </div>
      </div>
    </div>
  <?php endif; ?>
  <div id="backtotop"><a href="#"></a></div>

</div>
